#!/bin/sh

DPLY_PAGE_DEPLOYING_DONE_RESULT_MSG=""
DPLY_PAGE_DEPLOYING_DONE_RESULT_OK=0
DPLY_PAGE_DEPLOYING_DONE_RESULT_ERROR=1

DPLY_PAGE_DEPLOYING_DONE_RESULT_CODE=${DPLY_PAGE_DEPLOYING_DONE_RESULT_ERROR}
DPLY_PAGE_DEPLOYING_DONE_RESULT_ROLLING=0


dply_page_deploying_done() {
    debug_print "in function '${FUNCNAME[0]}'"
    
	local deploying_flag="/dev/shm/deploying.flag"
    local stepName="SyncMsIpToSc"
    local msg
    debug_print "${stepName}"
    msg=`php "${CONS_BACKEND}" sync_server_ip_to_controller "169.254.3.2" 1`
    local ret="${?}"
    if [ "${ret}" -ne 0 ]; then
        debug_print "${stepName}Fail: ret='${ret}', msg='${msg}'"
		rm -f "${deploying_flag}"
        
        DPLY_PAGE_DEPLOYING_DONE_RESULT_CODE=${DPLY_PAGE_DEPLOYING_DONE_RESULT_ERROR}
        DPLY_PAGE_DEPLOYING_DONE_RESULT_ROLLING=-2
        DPLY_PAGE_DEPLOYING_DONE_RESULT_MSG="${DPLY_PAGE_DEPLOYING_DONE_ERROR_SYNC_SETTING_TO_SC}"
        return
    fi
    sh notify_configuration_change.sh
    debug_print "${stepName}Pass: msg='${msg}'"

    if [ "${RT_MASTER_MODE}" -eq 1 ]; then
        local stepName="SwitchToMasterMode"
        local ret
        debug_print "${stepName}"
        utility_switch_to_master_mode
        ret="${?}"
        if [ "${ret}" -ne 0 ]; then
		    rm -f "${deploying_flag}"
            debug_print "${stepName}Fail: ret='${ret}'"
            DPLY_PAGE_DEPLOYING_DONE_RESULT_CODE=${DPLY_PAGE_DEPLOYING_DONE_RESULT_ERROR}
            DPLY_PAGE_DEPLOYING_DONE_RESULT_ROLLING=-2
            DPLY_PAGE_DEPLOYING_DONE_RESULT_MSG="${DPLY_PAGE_DEPLOYING_DONE_ERROR_SWITCH_TO_MASTER_MODE}"
            return
        fi
        debug_print "${stepName}Pass: msg='${msg}'"
    fi
    
    
    local stepName="ServiceEemaildStart"
    debug_print "${stepName}"
    msg=`service eemaild start`
    ret="${?}"
    if [ "${ret}" -ne 0 ]; then
        debug_print "${stepName}Fail: ret='${ret}', msg='${msg}'"
		rm -f "${deploying_flag}"
        
        DPLY_PAGE_DEPLOYING_DONE_RESULT_CODE=${DPLY_PAGE_DEPLOYING_DONE_RESULT_ERROR}
        DPLY_PAGE_DEPLOYING_DONE_RESULT_ROLLING=-2
        DPLY_PAGE_DEPLOYING_DONE_RESULT_MSG="${msg}"
        return
    fi
    debug_print "${stepName}Pass: msg='${msg}'"


    local stepName="SetEemaildStartOnBoot"
    debug_print "${stepName}"
    msg=`chkconfig eemaild on`
    ret="${?}"
    if [ "${ret}" -ne 0 ]; then
        debug_print "${stepName}Fail: ret='${ret}', msg='${msg}'"
		rm -f "${deploying_flag}"
        
        DPLY_PAGE_DEPLOYING_DONE_RESULT_CODE=${DPLY_PAGE_DEPLOYING_DONE_RESULT_ERROR}
        DPLY_PAGE_DEPLOYING_DONE_RESULT_ROLLING=-2
        DPLY_PAGE_DEPLOYING_DONE_RESULT_MSG="${msg}"
        return
    fi
    debug_print "${stepName}Pass: msg='${msg}'"

    
    conf_number_of_sb=`dtascfg "${DTASCFG_XML_FILE}" get sandbox number`
    debug_print "read </configuration/sandbox/number>: ${conf_number_of_sb}"
    
    conf_number_of_sb_for_master=`dtascfg "${DTASCFG_XML_FILE}" get sandbox number_for_master`
    debug_print "read </configuration/sandbox/number_for_master>: ${conf_number_of_sb_for_master}"

    local text=""
    if [ "${RT_MASTER_MODE}" -eq 1 ]; then
        text=`printf \
            "${DPLY_PAGE_DEPLOYING_DONE_TEXT}" \
            "${conf_number_of_sb_for_master}"`
    else
        text=`printf \
            "${DPLY_PAGE_DEPLOYING_DONE_TEXT}" \
            "${conf_number_of_sb}"`
    fi
    
	rm -f "${deploying_flag}"
    tp_msg_ok \
        "${DPLY_PAGE_DEPLOYING_DONE_TITLE}" \
        "${text}" \
        "${DPLY_PAGE_DEPLOYING_DONE_LABEL_OK}"
    
    # notice if network not available
    msg=`ethtool eth0 | grep "Link detected: yes" >/dev/null 2>&1`
    ret="${?}"
    
    if [ "${ret}" -eq 0 ]; then
        debug_print "[checking network] Network connection is available, msg='${msg}'"

    elif [ "${ret}" -eq 1 ]; then
        debug_print "[checking network] Network connection is not available, msg='${msg}'"
        tp_msg_ok \
            "${DPLY_PAGE_DEPLOYING_DONE_NETWORK_CHECK_TITLE}" \
            "${DPLY_PAGE_DEPLOYING_DONE_NETWORK_CHECK_TEXT}" \
            "${DPLY_PAGE_DEPLOYING_DONE_NETWORK_CHECK_LABEL_OK}"
    else
        debug_print "[checking network] Unknown Error! ret='${ret}', msg='${msg}'"
    fi
    
    DPLY_PAGE_DEPLOYING_DONE_RESULT_CODE=$DPLY_PAGE_DEPLOYING_DONE_RESULT_OK
    DPLY_PAGE_DEPLOYING_DONE_RESULT_ROLLING=1
    DPLY_PAGE_DEPLOYING_DONE_RESULT_MSG=""
}
